# disktest - Tester for Solid State Disks (SSDs), Non-Volatile Memory Storage (NVMe), Hard Disks (HDDs), USB Sticks, SD-Cards, etc.

[Homepage](https://bues.ch/h/disktest)

[Git repository](https://bues.ch/cgit/disktest.git)

[Github repository](https://github.com/mbuesch/disktest)

[crates.io site](https://crates.io/crates/disktest)


Disktest is a tool to check Solid State Disks, Non-Volatile Memory Storage, Hard Disks, USB sticks, SD cards or other storage media for errors.

It does so by writing a pseudo-random sequence to the device and then reading it back and verifying it against the same pseudo-random sequence.

This tool can be used to:

- Check disks for hardware errors (e.g. platter errors, flash errors, etc.).
- Overwrite storage media with a cryptographically-strong pseudo-random stream. This can either be used to delete existing data on the disk, or to prepare the disk for encryption.
- Test for tampered media that pretend to have more storage area than they physically have. Sometimes such media are sold by fraudulent sellers at cheap prices.
- Measure read and write speed.
- ... probably lots of other tasks.

The pseudo-random number stream is generated by the following algorithm:

```
OUTPUT_DATA := CHACHA20(PBKDF2(SEED | THREAD_ID | ROUND_ID))
```

If more than one thread is used, then each thread generates such a stream, and the streams are interleaved in an alternating pattern.


# Security

The default algorithm [ChaCha20](https://en.wikipedia.org/wiki/Salsa20) is a cryptographically strong random number generator. That means if the seed is kept secret, the pseudo-random sequence cannot be predicted or reconstructed by anybody else.

See option `--seed` under `--help` for more details.


# Linux example

The following disktest invocation will write a secure sequence to the disk device `/dev/sdc` and subsequently read back and verify the sequence.

```sh
disktest --write --verify -j0 /dev/sdc
```

For NVMe:

```sh
disktest --write --verify -j0 /dev/nvme0n1
```

For SD / MMC:

```sh
disktest --write --verify -j0 /dev/mmcblk0
```

*WARNING*: This will irrevocably overwrite all data on the storage device! Be absolutely certain that the device path is correct before starting the command. Your data will not be recoverable.

You probably need `root` permissions to write to raw disk devices (`/dev/sdX`, `/dev/nvmeXn1` or `/dev/mmcblkX`).

The target `device` does not have to be an actual hardware device node. It can be any file path on any file system. For example you can mount an USB stick file system and write to a file on that file system. However, please note that this leaves a couple of minor untested spots in the USB stick's memory, which are reserved for the file system. Also see the `Windows` section below.


# Windows example

On Windows disktest can write to any file on any mounted storage media or raw disks.

If your storage media under test is drive E, then the following command would write a test file on drive E and verify it:

```sh
disktest --write --verify -j0 E:\testfile.img
```

But note that testing on the filesystem level, as shown above, does not test the full device.
It will omit the disk areas that the filesystem uses internally.
Therefore, you may want to write to the raw disk E using the Windows raw drive notation, as follows:

```sh
disktest --write --verify -j0 \\.\E:
```

or

```sh
disktest --write --verify -j0 \\.\PhysicalDrive2
```

Doing so will completely wipe all data (including the filesystem) on this disk.

Always make sure that you selected the correct drive.
Especially in the `\\\\.\PhysicalDriveX` notation, it is extremely easy to overwrite the wrong drive by accident.
Therefore, the `\\\\.\X:` (where X is the drive letter) notation is preferred.


# Dependencies

- [Rust 1.75.0](https://www.rust-lang.org/) or later.
- Crate dependencies are automatically downloaded by Cargo.


# Installing from crates.io

Download the latest version of disktest from [crates.io](https://crates.io/) and install it to `$HOME/.cargo/bin`:

```sh
cargo install disktest
```


# Installing from source package

Build disktest and install it to `$HOME/.cargo/bin`:

```sh
cd path/to/source/package
cargo install --path .
```


# Running from source package without installing

Build and run disktest in place without installing it:

```sh
cd path/to/source/package
cargo run --release --  DISKTEST_OPTIONS_HERE
```

See below for a description of the available `disktest` options.


# Disktest command line options

Please run either of the following commands to show more information about the available command-line options.

```sh
cargo run --release -- --help
disktest --help
```


# Speed

The following table shows some example speed measurements of disktest in various operation modes on different hardware.

These speed tests don't write to an actual disk, but only to the `/dev/null` device, which is a device that does nothing. So these speed test results do not include the speed limits of any physical disk hardware.

| Command                               | Algorithm | Hardware                        | Data rate written |
| ------------------------------------- | --------- | ------------------------------- | ----------------- |
| disktest -j12 -ACHACHA20 -w /dev/null | ChaCha20  | AMD Ryzen 5 5500U; 6x2 cores    | 8.4 GiB/s         |
| disktest -j12 -ACHACHA12 -w /dev/null | ChaCha12  | AMD Ryzen 5 5500U; 6x2 cores    | 8.7 GiB/s         |
| disktest -j12 -ACHACHA8 -w /dev/null  | ChaCha8   | AMD Ryzen 5 5500U; 6x2 cores    | 8.7 GiB/s         |
| disktest -j12 -ACRC -w /dev/null      | CRC       | AMD Ryzen 5 5500U; 6x2 cores    | 8.8 GiB/s         |
| disktest -j4 -ACHACHA20 -w /dev/null  | ChaCha20  | Intel i5-3320M; 2x2 cores       | 2.1 GiB/s         |
| disktest -j4 -ACHACHA12 -w /dev/null  | ChaCha12  | Intel i5-3320M; 2x2 cores       | 3.3 GiB/s         |
| disktest -j4 -ACHACHA8 -w /dev/null   | ChaCha8   | Intel i5-3320M; 2x2 cores       | 4.5 GiB/s         |
| disktest -j4 -ACRC -w /dev/null       | CRC       | Intel i5-3320M; 2x2 cores       | 8.2 GiB/s         |
| disktest -j4 -ACHACHA20 -w /dev/null  | ChaCha20  | Raspberry Pi 4; 4 cores 1.5 GHz | 455 MiB/s         |
| disktest -j4 -ACHACHA12 -w /dev/null  | ChaCha12  | Raspberry Pi 4; 4 cores 1.5 GHz | 720 MiB/s         |
| disktest -j4 -ACHACHA8 -w /dev/null   | ChaCha8   | Raspberry Pi 4; 4 cores 1.5 GHz | 990 MiB/s         |
| disktest -j4 -ACRC -w /dev/null       | CRC       | Raspberry Pi 4; 4 cores 1.5 GHz | 3.1 GiB/s         |

The read data rates are similar because the algorithm used is exactly the same.


# CPU native optimization

Note that the default [cargo configuration](.cargo/config.toml) supplied with this package sets the Rust compiler option `-Ctarget-cpu=native` to optimize for the best performance on your CPU.

But this means that binaries compiled with this optimizations are non-portable to older CPUs.
If you want portable binaries, then you probably want to remove this optimization option.


# License

Copyright (c) 2020-2025 Michael Büsch <m@bues.ch> and contributors

Licensed under the Apache License version 2.0 or the MIT license, at your option.
